<?php
	error_reporting(E_ALL);
	include "/usr/local/webif/lib.php";
	$hostname = trim(file_get_contents("/etc/hostname"));
	$alert_flag = "0";
	
	$machine = trim(file_get_contents("/etc/machine"));
	if($machine == "RMS-100v2")
	{
		$dbh = new PDO('sqlite:/etc/rms100.db');	
	}
	if($machine == "RMS-200v2")
	{
		$dbh = new PDO('sqlite:/etc/rms200.db');	
	}
	if($machine == "RMS-300v2")
	{
		$dbh = new PDO('sqlite:/etc/rms300.db');	
	}
	
	$result  = $dbh->query("SELECT * FROM display_options;");			
	foreach($result as $row)
	{
		$screen_animations = $row['screen_animations'];
	}
	
/////////////////////////////////////////////////////////////////
//                                                             //
//                    GET PROCESSING                           //
//                                                             //
/////////////////////////////////////////////////////////////////


/////////////////////////////////////////////////////////////////
//                                                             //
//                    POST PROCESSING                          //
//                                                             //
/////////////////////////////////////////////////////////////////

// Strip illegal characters from $_POST data
$input_arr = array();
foreach ($_POST as $key => $input_arr)
{
  	$_POST[$key] = preg_replace("/[^a-zA-Z0-9s!@#$%&*()_-=+?.,:/]/", "", $input_arr);
}

// Cancel Button	was clicked
if(isset ($_POST['cancel_btn']))
{
	header("Location: setup.php");
}

	
// OK Button	was clicked
if(isset ($_POST['save_btn']))
{	
	//DO OK OR SAVE STUFF HERE
	
	$alert_flag = "1";
}

	
?>

<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">

    <!-- Page title -->
    <title><?php echo $hostname; ?></title>
    <?php
    $my_rand = rand();
    
    if($machine == "RMS-100v2")
		{
			echo "<link rel='shortcut icon' type='image/ico' href='../rms100favicon.ico?" . $my_rand . "' />";
		}
		if($machine == "RMS-200v2")
		{
			echo "<link rel='shortcut icon' type='image/ico' href='../rms200favicon.ico?" . $my_rand . "' />";
		}
		if($machine == "RMS-300v2")
		{
			echo "<link rel='shortcut icon' type='image/ico' href='../rms300favicon.ico?" . $my_rand . "' />";
		}
		?>

    <!-- CSS -->
    <link rel="stylesheet" href="../css/fontawesome/css/font-awesome.css" />
    <link rel="stylesheet" href="../css/animate.css" />
    <link rel="stylesheet" href="../css/bootstrap.css" />
    <link rel="stylesheet" href="../css/sweetalert.css" />
    <link rel="stylesheet" href="../css/ethertek.css">
    
    <!-- Java Scripts -->
		<script src="../javascript/jquery.min.js"></script>
		<script src="../javascript/bootstrap.min.js"></script>
		<script src="../javascript/sweetalert.min.js"></script>
		<script src="../javascript/conhelp.js"></script>
		<script src="../javascript/ethertek.js"></script>
		<script src='../javascript/bindows_gauges.js'></script>
		<script language="javascript" type="text/javascript">
			SetContext('setup');
		</script>
		
</head>
<body class="fixed-navbar fixed-sidebar">
<div class='splash'> <div class='solid-line'></div><div class='splash-title'><h1>Loading... Please Wait...</h1><div class='spinner'> <div class='rect1'></div> <div class='rect2'></div> <div class='rect3'></div> <div class='rect4'></div> <div class='rect5'></div> </div> </div> </div>

<!--[if lt IE 7]>
<p class="alert alert-danger">You are using an <strong>old</strong> web browser. Please upgrade your browser to improve your experience.</p>
<![endif]-->

<?php start_header(); ?>

<?php left_nav("custom"); ?>
<script language="javascript" type="text/javascript">
	SetContext('setup');
</script>


<script language="javascript" type="text/javascript">
// !!!!!!!!!!!!!!!!!!!!!!! FILL THIS IN FOR EACH SITE !!!!!!!!!!!!!!!!!!!!!!!
<?php $title="EDIT TITLE"; ?>					//EDIT THIS
Site = "EDIT SITE";										//EDIT THIS
EnteredDate = "Dec-25-2023";					//EDIT THIS
EmptyReadingValue = "0.1171";					//EDIT THIS
FullReadingValue = "0.023";						//EDIT THIS
GasGaugeVoltmeterNumber = 3;					//EDIT THIS
BatteryVoltmeterNumber = 1;						//EDIT THIS
GenStatusVM = 2;											//EDIT THIS
</script>




<!-- Main Wrapper -->
<div id="wrapper">
	
	<?php
		if($screen_animations == "CHECKED")
		{
			echo '<div class="content animate-panel" data-effect="fadeInUp">';
		}
		else
		{
			echo '<div class="content">';
		}
	?>
	
  	<!-- INFO BLOCK START -->
  	<div class="row">
    	<div class="col-sm-12">
      	<div class="hpanel4">
      		<div class="panel-body" style="max-width:600px">
      	  	<form name='CUSTOM' action='custom_device_template.php' method='post' class="form-horizontal">  	
      	    	<fieldset>
      	    		<legend><img src="images/panel-gauge-32x32.png"> <?php echo $title; ?></legend> 
      	    		
              	<table width="50%">
									<tr>
										<td width="50%">
											<!-- Each gas gauge needs its own Div -->
											<div id='gasgaugeDiv' style='width: 250; height: 250'></div>
										</td>
									</tr>
								</table>
								
								<table width="100%">
									<tr>
										<td width="50%">
											Site:
										</td>
										<td width="50%">
											<span id="Site"></span>
										</td>
									</tr>
									<tr>
										<td>
											Date when readings were entered:
										</td>
										<td>
											<span id="EnteredDate"></span>
										</td>
									</tr>
									<tr>
										<td>
											Voltage when tank is EMPTY: 
										</td>
										<td>
											<span id="VoltEmpty"></span>
										</td>
									</tr>
									<tr>
										<td>
											Voltage when tank is FULL: 
										</td>
										<td>
											<span id="VoltFull"></span>
										</td>
									</tr>
								</table>
								
								<br>
								
								<table width="100%">
									<tr>
										<td width="50%">
											Current reading: 
										</td>
										<td width="50%">
											<span id="VoltCurrent"></span>
										</td>
									</tr>
									<tr>
										<td width="50%">
											Voltage @ 15%: 
										</td>
										<td width="50%">
											<span id="Volt15p"></span>
										</td>
									</tr>
								</table>
								<br>
								<table width="100%">
									<tr>
										<td width="50%">
											Battery Volts: 
										</td>
										<td width="50%">
											<span id="RawBatteryVolts"></span>
										</td>
									</tr>
								</table>
								<br>
								<table width="100%">
									<tr>
										<td width="50%">
											Generator Status: 
										</td>
										<td width="50%">
											<span id="GenStatusVM"></span>
										</td>
									</tr>
								</table>
								 <br>
              </fieldset>  
						</form>  	
      		</div> <!-- END PANEL BODY --> 
      	</div> <!-- END PANEL WRAPPER --> 
      </div>  <!-- END COL --> 
    </div> <!-- END ROW --> 
  </div> <!-- END CONTENT -->    
</div> <!-- END Main Wrapper -->

<script language="javascript" type="text/javascript">
var gasgauge = bindows.loadGaugeIntoDiv('/custom/gas.xml', 'gasgaugeDiv');

function display_gauge() 
{
	// debugger;
	var STEPS = 100;

	$('#Site').text(Site);
	$('#EnteredDate').text(EnteredDate);
	$('#VoltEmpty').text(EmptyReadingValue);
	$('#VoltFull').text(FullReadingValue);
	
	var Percent15 = get15Percent(FullReadingValue, EmptyReadingValue, STEPS);
	$('#Volt15p').text(Percent15);
	
	var myRandom = parseInt(Math.random()*999999999);
    $.getJSON('/sdserver.php?element=vmall&rand=' + myRandom,function(data) {
		
		var RawVolts = eval('data.vms.vm' + GasGaugeVoltmeterNumber);
		var RawBattery = eval('data.vms.vm' + BatteryVoltmeterNumber);
		var GeneratorStatus = eval('data.vms.vm' + GenStatusVM);
		
		if(GeneratorStatus > 5) //if gen indicator voltage is > 5 volts.
		{
			$('#GenStatusVM').text("Gen Running");
		}
		else
		{
			$('#GenStatusVM').text("Gen Not Running");
		}
		
		$('#VoltCurrent').text(RawVolts);
		$('#RawBatteryVolts').text(RawBattery);

		var percent = 0.0;
		if(RawVolts > EmptyReadingValue)
			{
				percent = 0;
			}
		else if(RawVolts < FullReadingValue)
			{
				percent = 100;
			}
		else
			{
				percent = getVal(FullReadingValue, EmptyReadingValue, STEPS, RawVolts);
				percent = parseFloat(percent).toFixed(1);
			}
		
		var PER = percent + ' % Full';
		gasgauge.needle.setValue(percent);
		gasgauge.label.setText(PER);
	 });
	 setTimeout(display_gauge, 2000); 	// update every 2 seconds
}

function getVal(FULL, EMPTY, STEPS, RAW) 
{
	var RANGE = (EMPTY - FULL);
	var MvPerStep  = RANGE / STEPS;
	var INVERTED_EMPTY   = (1 - EMPTY);
	//var _INVERTED_FULL    = (1 - _FULL);
	var INVERTED_Voltage = (1 - RAW);
	return (INVERTED_Voltage - INVERTED_EMPTY) / MvPerStep;
}

function get15Percent(FULL, EMPTY, STEPS) {
	var RANGE = (EMPTY - FULL);
	var MvPerStep  = RANGE / STEPS;
	return parseFloat(EMPTY - (15 * MvPerStep)).toFixed(5);
}

display_gauge();
</script>

<?php 
if($alert_flag == "1")
{
echo"<script>";
echo"swal({";
echo"  title:'Success!',";
echo"  text: 'Settings Saved!',";
echo"  type: 'success',";
echo"  showConfirmButton: false,";
echo"  timer: 2000";
echo"});";
echo"</script>";
}
?>
</body>
</html> 
