﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace USBrelayTest
{
    public partial class MainForm : Form
    {
        private string myvid;
        private string mypid;
        public string man;
        public int dev_count;

        public MainForm()
        {
            InitializeComponent();
        }

        private void Connect_button_Click(object sender, EventArgs e)
        {
            dev_count = 0;
            var devs = HIDBrowse.Browse();
            /* display VID and PID for every device found */
            foreach (var dev in devs)
            {
                myvid = dev.Vid.ToString("X4");
                mypid = dev.Pid.ToString("X4");
                man = dev.Manufacturer;
                int sd = Math.Abs(dev.Pid);

                if ((myvid == "0000") && (man == "EtherTek") && (sd <= 32768))
                {
                    
                    //pid = dev.Pid.ToString("X4");
                    Debug_textbox.Text += ("VID = " + dev.Vid.ToString("X4") + "  PID = " + dev.Pid.ToString("X4") + "  " + dev.Product + "\r\n");
                    Get_M_Name_button.Enabled = true;
                    Energize_Relay_1_button.Enabled = true;
                    De_Energize_Relay_1_button.Enabled = true;
                    Energize_Relay_2_button.Enabled = true;
                    De_Energize_Relay_2_button.Enabled = true;
                    Energize_Relay_3_button.Enabled = true;
                    De_Energize_Relay_3_button.Enabled = true;
                    Energize_Relay_4_button.Enabled = true;
                    De_Energize_Relay_4_button.Enabled = true;
                    Energize_Relay_5_button.Enabled = true;
                    De_Energize_Relay_5_button.Enabled = true;
                    Read_Status_button.Enabled = true;
                    Relay_1_LED_checkbox.Enabled = true;
                    Relay_2_LED_checkbox.Enabled = true;
                    Relay_3_LED_checkbox.Enabled = true;
                    Relay_4_LED_checkbox.Enabled = true;
                    Relay_5_LED_checkbox.Enabled = true;
                    heartbeatLED_checkbox.Enabled = true;

                    GetStatus();

                    break;
                }
                dev_count++;
            }
        }

        private void Get_M_Name_button_Click(object sender, EventArgs e)
        {
            Debug_textbox.Text += "Manufacturer: " + man + "\r\n";
            //GetManufacturer(dev);
        }

        private void Energize_Relay_1_button_Click(object sender, EventArgs e)
        {
            //Energize Relay 1
            HIDDev dev = new HIDDev();
            var devs = HIDBrowse.Browse();
            dev.Open(devs[dev_count]);
            //ETek2
            byte[] report = new byte[33];
            report[0] = 0x00; //0
            report[1] = 0x45; //E
            report[2] = 0x54; //T
            report[3] = 0x65; //e
            report[4] = 0x6B; //k
            report[5] = 0x01; //1
            report[6] = 0x00; //0
            /* send report */
            dev.Write(report);
            Debug_textbox.Text += "Relay 1 Energized\r\n";
            dev.Close();
        }

        private void De_Energize_Relay_1_button_Click(object sender, EventArgs e)
        {
            //De-Energize Relay 1
            HIDDev dev = new HIDDev();
            var devs = HIDBrowse.Browse();
            dev.Open(devs[dev_count]);
            //ETek1
            byte[] report = new byte[33];
            report[0] = 0x00; //0
            report[1] = 0x45; //E
            report[2] = 0x54; //T
            report[3] = 0x65; //e
            report[4] = 0x6B; //k
            report[5] = 0x00; //0
            report[6] = 0x00; //0
            /* send report */
            dev.Write(report);
            Debug_textbox.Text += "Relay 1 De-Energized\r\n";
            dev.Close();
        }

        private void Energize_Relay_2_button_Click(object sender, EventArgs e)
        {
            //Energize Relay 2
            HIDDev dev = new HIDDev();
            var devs = HIDBrowse.Browse();
            dev.Open(devs[dev_count]);
            //ETek2
            byte[] report = new byte[33];
            report[0] = 0x00; //0
            report[1] = 0x45; //E
            report[2] = 0x54; //T
            report[3] = 0x65; //e
            report[4] = 0x6B; //k
            report[5] = 0x03; //3
            report[6] = 0x00; //0
            /* send report */
            dev.Write(report);
            Debug_textbox.Text += "Relay 2 Energized\r\n";
            dev.Close();
        }

        private void De_Energize_Relay_2_button_Click(object sender, EventArgs e)
        {
            //De-Energize Relay 2
            HIDDev dev = new HIDDev();
            var devs = HIDBrowse.Browse();
            dev.Open(devs[dev_count]);
            //ETek1
            byte[] report = new byte[33];
            report[0] = 0x00; //0
            report[1] = 0x45; //E
            report[2] = 0x54; //T
            report[3] = 0x65; //e
            report[4] = 0x6B; //k
            report[5] = 0x02; //2
            report[6] = 0x00; //0
            /* send report */
            dev.Write(report);
            Debug_textbox.Text += "Relay 2 De-Energized\r\n";
            dev.Close();
        }

        private void Energize_Relay_3_button_Click(object sender, EventArgs e)
        {
            //Energize Relay 3
            HIDDev dev = new HIDDev();
            var devs = HIDBrowse.Browse();
            dev.Open(devs[dev_count]);
            //ETek2
            byte[] report = new byte[33];
            report[0] = 0x00; //0
            report[1] = 0x45; //E
            report[2] = 0x54; //T
            report[3] = 0x65; //e
            report[4] = 0x6B; //k
            report[5] = 0x05; //5
            report[6] = 0x00; //0
            /* send report */
            dev.Write(report);
            Debug_textbox.Text += "Relay 3 Energized\r\n";
            dev.Close();
        }

        private void De_Energize_Relay_3_button_Click(object sender, EventArgs e)
        {
            //De-Energize Relay 3
            HIDDev dev = new HIDDev();
            var devs = HIDBrowse.Browse();
            dev.Open(devs[dev_count]);
            //ETek1
            byte[] report = new byte[33];
            report[0] = 0x00; //0
            report[1] = 0x45; //E
            report[2] = 0x54; //T
            report[3] = 0x65; //e
            report[4] = 0x6B; //k
            report[5] = 0x04; //4
            report[6] = 0x00; //0
            /* send report */
            dev.Write(report);
            Debug_textbox.Text += "Relay 3 De-Energized\r\n";
            dev.Close();
        }

        private void Energize_Relay_4_button_Click(object sender, EventArgs e)
        {
            //Energize Relay 4
            HIDDev dev = new HIDDev();
            var devs = HIDBrowse.Browse();
            dev.Open(devs[dev_count]);
            //ETek2
            byte[] report = new byte[33];
            report[0] = 0x00; //0
            report[1] = 0x45; //E
            report[2] = 0x54; //T
            report[3] = 0x65; //e
            report[4] = 0x6B; //k
            report[5] = 0x07; //7
            report[6] = 0x00; //0
            /* send report */
            dev.Write(report);
            Debug_textbox.Text += "Relay 4 Energized\r\n";
            dev.Close();
        }

        private void De_Energize_Relay_4_button_Click(object sender, EventArgs e)
        {
            //De-Energize Relay 4
            HIDDev dev = new HIDDev();
            var devs = HIDBrowse.Browse();
            dev.Open(devs[dev_count]);
            //ETek1
            byte[] report = new byte[33];
            report[0] = 0x00; //0
            report[1] = 0x45; //E
            report[2] = 0x54; //T
            report[3] = 0x65; //e
            report[4] = 0x6B; //k
            report[5] = 0x06; //6
            report[6] = 0x00; //0
            /* send report */
            dev.Write(report);
            Debug_textbox.Text += "Relay 4 De-Energized\r\n";
            dev.Close();
        }

        private void Energize_Relay_5_button_Click(object sender, EventArgs e)
        {
            //Energize Relay 5
            HIDDev dev = new HIDDev();
            var devs = HIDBrowse.Browse();
            dev.Open(devs[dev_count]);
            //ETek2
            byte[] report = new byte[33];
            report[0] = 0x00; //0
            report[1] = 0x45; //E
            report[2] = 0x54; //T
            report[3] = 0x65; //e
            report[4] = 0x6B; //k
            report[5] = 0x09; //9
            report[6] = 0x00; //0
            /* send report */
            dev.Write(report);
            Debug_textbox.Text += "Relay 5 Energized\r\n";
            dev.Close();
        }

        private void De_Energize_Relay_5_button_Click(object sender, EventArgs e)
        {
            //De-Energize Relay 5
            HIDDev dev = new HIDDev();
            var devs = HIDBrowse.Browse();
            dev.Open(devs[dev_count]);
            //ETek1
            byte[] report = new byte[33];
            report[0] = 0x00; //0
            report[1] = 0x45; //E
            report[2] = 0x54; //T
            report[3] = 0x65; //e
            report[4] = 0x6B; //k
            report[5] = 0x08; //8
            report[6] = 0x00; //0
            /* send report */
            dev.Write(report);
            Debug_textbox.Text += "Relay 5 De-Energized\r\n";
            dev.Close();
        }

        private void Relay_1_LED_checkbox_Click(object sender, EventArgs e)
        {
            if (Relay_1_LED_checkbox.Checked == true)
            {
                Debug_textbox.Text += "RELAY 1 LED ON\r\n";
            }
            else
            {
                Debug_textbox.Text += "RELAY 1 LED OFF\r\n";
            }

            //First, Read Relay and LED Status
            HIDDev dev = new HIDDev();
            var devs = HIDBrowse.Browse();
            dev.Open(devs[dev_count]);
            //ETek10
            byte[] report = new byte[33];
            report[0] = 0x00; //0
            report[1] = 0x45; //E
            report[2] = 0x54; //T
            report[3] = 0x65; //e
            report[4] = 0x6B; //k
            report[5] = 0x0A; //10
            report[6] = 0x00; //0
            /* send report */
            dev.Write(report);

            dev.Read(report);

            byte myByte1;
            myByte1 = report[8];
            byte myByte2 = (byte)(myByte1 ^ 1);

            //ETek11, write LED BITS
            report[0] = 0x00; //0
            report[1] = 0x45; //E
            report[2] = 0x54; //T
            report[3] = 0x65; //e
            report[4] = 0x6B; //k
            report[5] = 0x0B; //11
            report[6] = myByte2; //RELAY 1 LED is bit 1 of myByte2

            /* send report */
            dev.Write(report);
            dev.Close();
        }

        private void Relay_2_LED_checkbox_Click(object sender, EventArgs e)
        {
            if (Relay_1_LED_checkbox.Checked == true)
            {
                Debug_textbox.Text += "RELAY 2 LED ON\r\n";
            }
            else
            {
                Debug_textbox.Text += "RELAY 2 LED OFF\r\n";
            }

            //First, Read Relay and LED Status
            HIDDev dev = new HIDDev();
            var devs = HIDBrowse.Browse();
            dev.Open(devs[dev_count]);
            //ETek10
            byte[] report = new byte[33];
            report[0] = 0x00; //0
            report[1] = 0x45; //E
            report[2] = 0x54; //T
            report[3] = 0x65; //e
            report[4] = 0x6B; //k
            report[5] = 0x0A; //10
            report[6] = 0x00; //0
            /* send report */
            dev.Write(report);

            dev.Read(report);

            byte myByte1;
            myByte1 = report[8];
            byte myByte2 = (byte)(myByte1 ^ 2);

            //ETek11, write LED BITS
            report[0] = 0x00; //0
            report[1] = 0x45; //E
            report[2] = 0x54; //T
            report[3] = 0x65; //e
            report[4] = 0x6B; //k
            report[5] = 0x0B; //11
            report[6] = myByte2; //RELAY 2 LED is bit 2 of myByte2

            /* send report */
            dev.Write(report);
            dev.Close();
        }

        private void Relay_3_LED_checkbox_Click(object sender, EventArgs e)
        {
            if (Relay_1_LED_checkbox.Checked == true)
            {
                Debug_textbox.Text += "RELAY 3 LED ON\r\n";
            }
            else
            {
                Debug_textbox.Text += "RELAY 3 LED OFF\r\n";
            }

            //First, Read Relay and LED Status
            HIDDev dev = new HIDDev();
            var devs = HIDBrowse.Browse();
            dev.Open(devs[dev_count]);
            //ETek10
            byte[] report = new byte[33];
            report[0] = 0x00; //0
            report[1] = 0x45; //E
            report[2] = 0x54; //T
            report[3] = 0x65; //e
            report[4] = 0x6B; //k
            report[5] = 0x0A; //10
            report[6] = 0x00; //0
            /* send report */
            dev.Write(report);

            dev.Read(report);

            byte myByte1;
            myByte1 = report[8];
            byte myByte2 = (byte)(myByte1 ^ 4);

            //ETek11, write LED BITS
            report[0] = 0x00; //0
            report[1] = 0x45; //E
            report[2] = 0x54; //T
            report[3] = 0x65; //e
            report[4] = 0x6B; //k
            report[5] = 0x0B; //11
            report[6] = myByte2; //RELAY 3 LED is bit 3 of myByte2

            /* send report */
            dev.Write(report);
            dev.Close();
        }

        private void Relay_4_LED_checkbox_Click(object sender, EventArgs e)
        {
            if (Relay_1_LED_checkbox.Checked == true)
            {
                Debug_textbox.Text += "RELAY 4 LED ON\r\n";
            }
            else
            {
                Debug_textbox.Text += "RELAY 4 LED OFF\r\n";
            }

            //First, Read Relay and LED Status
            HIDDev dev = new HIDDev();
            var devs = HIDBrowse.Browse();
            dev.Open(devs[dev_count]);
            //ETek10
            byte[] report = new byte[33];
            report[0] = 0x00; //0
            report[1] = 0x45; //E
            report[2] = 0x54; //T
            report[3] = 0x65; //e
            report[4] = 0x6B; //k
            report[5] = 0x0A; //10
            report[6] = 0x00; //0
            /* send report */
            dev.Write(report);

            dev.Read(report);

            byte myByte1;
            myByte1 = report[8];
            byte myByte2 = (byte)(myByte1 ^ 8);

            //ETek11, write LED BITS
            report[0] = 0x00; //0
            report[1] = 0x45; //E
            report[2] = 0x54; //T
            report[3] = 0x65; //e
            report[4] = 0x6B; //k
            report[5] = 0x0B; //11
            report[6] = myByte2; //RELAY 4 LED is bit 4 of myByte2

            /* send report */
            dev.Write(report);
            dev.Close();
        }

        private void Relay_5_LED_checkbox_Click(object sender, EventArgs e)
        {
            if (Relay_1_LED_checkbox.Checked == true)
            {
                Debug_textbox.Text += "RELAY 5 LED ON\r\n";
            }
            else
            {
                Debug_textbox.Text += "RELAY 5 LED OFF\r\n";
            }

            //First, Read Relay and LED Status
            HIDDev dev = new HIDDev();
            var devs = HIDBrowse.Browse();
            dev.Open(devs[dev_count]);
            //ETek10
            byte[] report = new byte[33];
            report[0] = 0x00; //0
            report[1] = 0x45; //E
            report[2] = 0x54; //T
            report[3] = 0x65; //e
            report[4] = 0x6B; //k
            report[5] = 0x0A; //10
            report[6] = 0x00; //0
            /* send report */
            dev.Write(report);

            dev.Read(report);

            byte myByte1;
            myByte1 = report[8];
            byte myByte2 = (byte)(myByte1 ^ 16);

            //ETek11, write LED BITS
            report[0] = 0x00; //0
            report[1] = 0x45; //E
            report[2] = 0x54; //T
            report[3] = 0x65; //e
            report[4] = 0x6B; //k
            report[5] = 0x0B; //11
            report[6] = myByte2; //RELAY 5 LED is bit 5 of myByte2

            /* send report */
            dev.Write(report);
            dev.Close();
        }

        private void heartbeatLED_checkbox_Click(object sender, EventArgs e)
        {
            if (heartbeatLED_checkbox.Checked == true)
            {
                Debug_textbox.Text += "HEARTBEAT LED ON\r\n";
            }
            else
            {
                Debug_textbox.Text += "HEARTBEAT LED OFF\r\n";
            }

            //First, Read Relay and LED Status
            HIDDev dev = new HIDDev();
            var devs = HIDBrowse.Browse();
            dev.Open(devs[dev_count]);
            //ETek10
            byte[] report = new byte[33];
            report[0] = 0x00; //0
            report[1] = 0x45; //E
            report[2] = 0x54; //T
            report[3] = 0x65; //e
            report[4] = 0x6B; //k
            report[5] = 0x0A; //10
            report[6] = 0x00; //0
            /* send report */
            dev.Write(report);

            dev.Read(report);

            byte myByte1;
            myByte1 = report[8];
            byte myByte2 = (byte)(myByte1 ^ 32);

            //ETek11, write LED BITS
            report[0] = 0x00; //0
            report[1] = 0x45; //E
            report[2] = 0x54; //T
            report[3] = 0x65; //e
            report[4] = 0x6B; //k
            report[5] = 0x0B; //11
            report[6] = myByte2; //HEARTBEAT is bit 6 of myByte2
            
            /* send report */
            dev.Write(report);
            dev.Close();    
        }

        private void Read_Status_button_Click(object sender, EventArgs e)
        {
            //Read Relay and LED Status
            HIDDev dev = new HIDDev();
            var devs = HIDBrowse.Browse();
            dev.Open(devs[dev_count]);
            //ETek10
            byte[] report = new byte[33];
            report[0] = 0x00; //0
            report[1] = 0x45; //E
            report[2] = 0x54; //T
            report[3] = 0x65; //e
            report[4] = 0x6B; //k
            report[5] = 0x0A; //10
            report[6] = 0x00; //0
            /* send report */
            dev.Write(report);

            dev.Read(report);

            Debug_textbox.Text += "Read Status:\r\n";
            Debug_textbox.Text += "Relay 1: ";
            Debug_textbox.Text += report[2].ToString("X1");
            Debug_textbox.Text += "\r\n";
            Debug_textbox.Text += "Relay 2: ";
            Debug_textbox.Text += report[3].ToString("X1");
            Debug_textbox.Text += "\r\n";
            Debug_textbox.Text += "Relay 3: ";
            Debug_textbox.Text += report[4].ToString("X1");
            Debug_textbox.Text += "\r\n";
            Debug_textbox.Text += "Relay 4: ";
            Debug_textbox.Text += report[5].ToString("X1");
            Debug_textbox.Text += "\r\n";
            Debug_textbox.Text += "Relay 5: ";
            Debug_textbox.Text += report[6].ToString("X1");
            Debug_textbox.Text += "\r\n";
            Debug_textbox.Text += "LED BITS: ";
            string myByteString = Convert.ToString(report[8], 2).PadLeft(8, '0');
            Debug_textbox.Text += myByteString;
            Debug_textbox.Text += "\r\n";
            Debug_textbox.Text += "Firmware Version: ";
            Debug_textbox.Text += Convert.ToChar(report[9]).ToString();
            Debug_textbox.Text += Convert.ToChar(report[10]).ToString();
            Debug_textbox.Text += Convert.ToChar(report[11]).ToString();
            Debug_textbox.Text += Convert.ToChar(report[12]).ToString();
            Debug_textbox.Text += "\r\n";

            dev.Close();
        }

        private void GetStatus()
        {
            //Read Relay, LED, and Firmware Status
            HIDDev dev = new HIDDev();
            var devs = HIDBrowse.Browse();
            dev.Open(devs[dev_count]);
            //ETek10
            byte[] report = new byte[33];
            report[0] = 0x00; //0
            report[1] = 0x45; //E
            report[2] = 0x54; //T
            report[3] = 0x65; //e
            report[4] = 0x6B; //k
            report[5] = 0x0A; //10 Read Status
            report[6] = 0x00; //0
            /* send report */
            dev.Write(report);

            dev.Read(report);

            byte myByte1;
            myByte1 = report[8];
            if((byte)(myByte1 & 1) == 1)
            {
                Relay_1_LED_checkbox.Checked = true;
            }
            else
            {
                Relay_1_LED_checkbox.Checked = false;
            }

            if ((byte)(myByte1 & 2) == 2)
            {
                Relay_2_LED_checkbox.Checked = true;
            }
            else
            {
                Relay_2_LED_checkbox.Checked = false;
            }

            if ((byte)(myByte1 & 4) == 4)
            {
                Relay_3_LED_checkbox.Checked = true;
            }
            else
            {
                Relay_3_LED_checkbox.Checked = false;
            }

            if ((byte)(myByte1 & 8) == 8)
            {
                Relay_4_LED_checkbox.Checked = true;
            }
            else
            {
                Relay_4_LED_checkbox.Checked = false;
            }

            if ((byte)(myByte1 & 16) == 16)
            {
                Relay_5_LED_checkbox.Checked = true;
            }
            else
            {
                Relay_5_LED_checkbox.Checked = false;
            }

            if ((byte)(myByte1 & 32) == 32)
            {
                heartbeatLED_checkbox.Checked = true;
            }
            else
            {
                heartbeatLED_checkbox.Checked = false;
            }

            fw_oct1_label.Text = Convert.ToChar(report[9]).ToString();
            fw_oct2_label.Text = Convert.ToChar(report[10]).ToString();
            fw_oct3_label.Text = Convert.ToChar(report[11]).ToString();
            fw_oct4_label.Text = Convert.ToChar(report[12]).ToString();
        }
    }
}
