.386
.model flat,stdcall
option casemap:none

include ASM-USBisoVM.inc

.code

start:

	invoke GetModuleHandle,NULL
	mov    hInstance,eax
	invoke GetCommandLine
	invoke InitCommonControls
	mov		CommandLine,eax
	invoke WinMain,hInstance,NULL,CommandLine,SW_SHOWDEFAULT
	invoke ExitProcess,eax

WinMain proc hInst:HINSTANCE,hPrevInst:HINSTANCE,CmdLine:LPSTR,CmdShow:DWORD
	LOCAL	wc:WNDCLASSEX
	LOCAL	msg:MSG

	mov		wc.cbSize,sizeof WNDCLASSEX
	mov		wc.style,CS_HREDRAW or CS_VREDRAW
	mov		wc.lpfnWndProc,offset WndProc
	mov		wc.cbClsExtra,NULL
	mov		wc.cbWndExtra,DLGWINDOWEXTRA
	push	hInst
	pop		wc.hInstance
	mov		wc.hbrBackground,COLOR_BTNFACE+1
	mov		wc.lpszMenuName,NULL
	mov		wc.lpszClassName,offset ClassName
	invoke LoadIcon,NULL,IDI_APPLICATION
	mov		wc.hIcon,eax
	mov		wc.hIconSm,eax
	invoke LoadCursor,NULL,IDC_ARROW
	mov		wc.hCursor,eax
	invoke RegisterClassEx,addr wc
	invoke CreateDialogParam,hInstance,IDD_DIALOG,NULL,addr WndProc,NULL
	invoke ShowWindow,hWnd,SW_SHOWNORMAL
	invoke UpdateWindow,hWnd
	.while TRUE
		invoke GetMessage,addr msg,NULL,0,0
	  .BREAK .if !eax
		invoke TranslateMessage,addr msg
		invoke DispatchMessage,addr msg
	.endw
	mov		eax,msg.wParam
	ret

WinMain endp

WndProc proc uses esi hWin:HWND,uMsg:UINT,wParam:WPARAM,lParam:LPARAM

	;
	;
	;	NOTE: This is a very basic example of calling functions from the USBisoVM_DLL.dll
	;	Normally you would include sanity checking and error handlers.
	;
	;

	mov		eax,uMsg
	.if eax==WM_INITDIALOG
		push	hWin
		pop		hWnd
		;show voltmeter icon on window
		invoke LoadIcon,hInstance,700
		invoke SendMessage, hWin, WM_SETICON, TRUE, eax
			
	.elseif eax==WM_COMMAND
		mov		eax,wParam
		and		eax,0FFFFh
		
		.if eax==TESTDLL_BTN
			invoke TestDLL, ADDR buffer ; test if DLL present
			.if eax==0
				;error occured
				;handle it here
			.endif
			invoke AppendText,hWnd,TEXTBOX,ADDR buffer,ADDR CRLF
			
		.elseif eax==FINDUSBISOVMS_BTN
			invoke FindUSBisoVMs, ADDR buffer ; find attached USBisoVMs
			.if eax==0
				;error occured
				;handle it here
			.endif
			invoke szCopy,ADDR buffer, ADDR FoundUSBisoVM
			lea esi,FoundUSBisoVM
			mov eax,0
			mov [esi+4],al ; strip seperator
			invoke AppendText,hWnd,TEXTBOX,ADDR FoundUSBisoVM,ADDR CRLF
			;enable buttons
			invoke GetDlgItem,hWnd,GETMANUFACTURERSTRING_BTN
			invoke EnableWindow,eax,TRUE ; enable GETMANUFACTURERSTRING_BTN	
			invoke GetDlgItem,hWnd,GETPRODUCTSTRING_BTN
			invoke EnableWindow,eax,TRUE ; enable GETPRODUCTSTRING_BTN	
			invoke GetDlgItem,hWnd,GETVERSIONSTRING_BTN
			invoke EnableWindow,eax,TRUE ; enable GETVERSIONSTRING_BTN
			invoke GetDlgItem,hWnd,VOLTMETER1_BTN
			invoke EnableWindow,eax,TRUE ; enable VOLTMETER1_BTN
			invoke GetDlgItem,hWnd,VOLTMETER2_BTN
			invoke EnableWindow,eax,TRUE ; enable VOLTMETER2_BTN
			invoke GetDlgItem,hWnd,VOLTMETER3_BTN
			invoke EnableWindow,eax,TRUE ; enable VOLTMETER3_BTN
			invoke GetDlgItem,hWnd,VOLTMETER4_BTN
			invoke EnableWindow,eax,TRUE ; enable VOLTMETER4_BTN
			invoke GetDlgItem,hWnd,VOLTMETER5_BTN
			invoke EnableWindow,eax,TRUE ; enable VOLTMETER5_BTN
			invoke GetDlgItem,hWnd,VOLTMETER6_BTN
			invoke EnableWindow,eax,TRUE ; enable VOLTMETER6_BTN
		
		.elseif eax==GETMANUFACTURERSTRING_BTN
			invoke htodw,ADDR FoundUSBisoVM							;convert Hex string to DW
			invoke GetManufacturerString,eax,ADDR buffer			;call function from DLL
			.if eax==0
				;error occured
				;handle it here
			.endif
			invoke AppendText,hWnd,TEXTBOX,ADDR buffer,ADDR CRLF	;Append it to the Text Box
		
		.elseif eax==GETPRODUCTSTRING_BTN
			invoke htodw,ADDR FoundUSBisoVM
			invoke GetProductString,eax,ADDR buffer
			.if eax==0
				;error occured
				;handle it here
			.endif
			invoke AppendText,hWnd,TEXTBOX,ADDR buffer,ADDR CRLF
		
		.elseif eax==GETVERSIONSTRING_BTN
			invoke htodw,ADDR FoundUSBisoVM
			invoke GetVersionString,eax,ADDR buffer
			.if eax==0
				;error occured
				;handle it here
			.endif
			invoke AppendText,hWnd,TEXTBOX,ADDR buffer,ADDR CRLF
		
		.elseif eax==VOLTMETER1_BTN
			invoke htodw,ADDR FoundUSBisoVM
			invoke ReadUSBisoVM,eax,1,1,ADDR buffer
			.if eax==0
				;error occured
				;handle it here
			.endif
			invoke AppendText,hWnd,TEXTBOX,ADDR buffer,ADDR CRLF
			
		.elseif eax==VOLTMETER2_BTN
			invoke htodw,ADDR FoundUSBisoVM
			invoke ReadUSBisoVM,eax,2,1,ADDR buffer
			.if eax==0
				;error occured
				;handle it here
			.endif
			invoke AppendText,hWnd,TEXTBOX,ADDR buffer,ADDR CRLF
			
		.elseif eax==VOLTMETER3_BTN
			invoke htodw,ADDR FoundUSBisoVM
			invoke ReadUSBisoVM,eax,3,1,ADDR buffer
			.if eax==0
				;error occured
				;handle it here
			.endif
			invoke AppendText,hWnd,TEXTBOX,ADDR buffer,ADDR CRLF
			
		.elseif eax==VOLTMETER4_BTN
			invoke htodw,ADDR FoundUSBisoVM
			invoke ReadUSBisoVM,eax,4,1,ADDR buffer
			.if eax==0
				;error occured
				;handle it here
			.endif
			invoke AppendText,hWnd,TEXTBOX,ADDR buffer,ADDR CRLF
			
		.elseif eax==VOLTMETER5_BTN
			invoke htodw,ADDR FoundUSBisoVM
			invoke ReadUSBisoVM,eax,5,1,ADDR buffer
			.if eax==0
				;error occured
				;handle it here
			.endif
			invoke AppendText,hWnd,TEXTBOX,ADDR buffer,ADDR CRLF
			
		.elseif eax==VOLTMETER6_BTN
			invoke htodw,ADDR FoundUSBisoVM
			invoke ReadUSBisoVM,eax,6,1,ADDR buffer
			.if eax==0
				;error occured
				;handle it here
			.endif
			invoke AppendText,hWnd,TEXTBOX,ADDR buffer,ADDR CRLF
		
		.elseif eax==ABOUT_BTN
			invoke MessageBox,hWnd,ADDR AboutMsg,ADDR AppName,MB_OK
		
		.elseif eax==EXIT_BTN
			invoke SendMessage,hWin,WM_CLOSE,0,0
				
		.endif
;	.elseif eax==WM_SIZE
	.elseif eax==WM_CLOSE
		invoke DestroyWindow,hWin
	.elseif uMsg==WM_DESTROY
		invoke PostQuitMessage,NULL
	.else
		invoke DefWindowProc,hWin,uMsg,wParam,lParam
		ret
	.endif
	xor    eax,eax
	ret

WndProc endp

; ########################################################################
; Append Text Procedure
; ########################################################################
AppendText proc dwhWnd:DWORD, ctrlid:DWORD, lpBuffer:DWORD, lpCRLF:DWORD
  invoke SendDlgItemMessage,dwhWnd,ctrlid,EM_SETSEL,0,-1
  invoke SendDlgItemMessage,dwhWnd,ctrlid,EM_SETSEL,-1,0
  invoke SendDlgItemMessage,dwhWnd,ctrlid,EM_REPLACESEL,FALSE,lpBuffer
  invoke SendDlgItemMessage,dwhWnd,ctrlid,EM_REPLACESEL,0,lpCRLF
  ret
AppendText endp

end start
