﻿/**********************************************************************
 * CSHARP2008 USBisoExample .NET 2.0 or higher required
 * 04/05/2010
 * This example is only to demonstrate the functions required to 
 * query the USBisoVm board values with the help of USBisoVM_DLL.dll. 
 * This code is intended only for example purposes and contains limited
 * error handing.
 * You may use this code in your own project.
 * ********************************************************************/
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.IO;
using System.Runtime.InteropServices;


namespace CSHARP2008_USBisoVMexample
{
    public partial class Form1 : Form
    {
        //import the dll and define the function calls
        [DllImport("USBisoVM_DLL.dll", CharSet = CharSet.Auto)]
        private static extern int TestDLL(byte[] buffer);

        [DllImport("USBisoVM_DLL.dll", CharSet = CharSet.Auto)]
        private static extern int FindUSBisoVMs(byte[] buffer);

        [DllImport("USBisoVM_DLL.dll", CharSet = CharSet.Auto)]
        private static extern int GetManufacturerString(int ID, byte[] buffer);

        [DllImport("USBisoVM_DLL.dll", CharSet = CharSet.Auto)]
        private static extern int GetProductString(int ID, byte[] buffer);

        [DllImport("USBisoVM_DLL.dll", CharSet = CharSet.Auto)]
        private static extern int GetVersionString(int ID, byte[] buffer);

        [DllImport("USBisoVM_DLL.dll", CharSet = CharSet.Auto)]
        private static extern int ReadUSBisoVM(int ID, int VM, int FORMAT, byte[] buffer);


        //Make a 1024 byte buffer that gets filled by the USBisoVM_DLL.dll
        private Encoding Encoding = System.Text.Encoding.ASCII;
        //Global variable that holds the first usb isolated voltmeter board found
        private string isoVMfound = string.Empty;
   

        public Form1()
        {
            InitializeComponent();
            textBox1.Text = "(C)opyright 2010 EtherTek Circuits";
            textBox1.AppendText("\r\n");
        }

        private void button1_Click(object sender, EventArgs e)
        {
            //Call test dll function
            byte[] buffer = new byte[1024];
            int errnum = TestDLL(buffer);          
            textBox1.AppendText(Encoding.GetString(buffer));
            textBox1.AppendText("\r\n");

            
        }

        private void button2_Click(object sender, EventArgs e)
        {
            //Find any connected USBIsoVm boards. This example will only display the first one found.
            byte[] buffer = new byte[1024];
            int errnum = FindUSBisoVMs(buffer);
            
            if (errnum == 0)
            {
                textBox1.AppendText("ERROR No USBISO boards found!\r\n");
                return;
            }

            isoVMfound = Encoding.GetString(buffer, 0, 4);
            textBox1.AppendText(isoVMfound);
            textBox1.AppendText("\r\n");
           

            //enable buttons
            button3.Enabled = true;
            button4.Enabled = true;
            button5.Enabled = true;
            button6.Enabled = true;
            button7.Enabled = true;
            button8.Enabled = true;
            button9.Enabled = true;
            button10.Enabled = true;
            button11.Enabled = true;
            
              
        }

 

        private void button3_Click(object sender, EventArgs e)
        {
            //call the GetManufacturerString function.
            //Returns the Manufacturer String unless there is an error.
            byte[] buffer = new byte[1024];
            int ID = System.Int16.Parse(isoVMfound, System.Globalization.NumberStyles.AllowHexSpecifier);
            int errnum = GetManufacturerString(ID, buffer);
            
            if (errnum == 0)
            {
                textBox1.AppendText("ERROR Function Call Failed\r\n");
                return;
            }

            Encoding.GetString(buffer, 0, 32).Replace("\0", "");
            textBox1.AppendText(Encoding.GetString(buffer, 0, 32).Replace("\0", ""));
            textBox1.AppendText("\r\n");
               
            

        }

        private void button4_Click(object sender, EventArgs e)
        {
            //call the GetProductString function.
            //Returns the Product String unless there is an error.
            byte[] buffer = new byte[1024];
            int ID = System.Int16.Parse(isoVMfound, System.Globalization.NumberStyles.AllowHexSpecifier);
            int errnum = GetProductString(ID, buffer);

            if (errnum == 0)
            {
                textBox1.AppendText("ERROR Function Call Failed\r\n");
                return;
            }

            Encoding.GetString(buffer, 0, 32).Replace("\0", "");
            textBox1.AppendText(Encoding.GetString(buffer).Replace("\0", ""));
            textBox1.AppendText("\r\n");
        }

        private void button5_Click(object sender, EventArgs e)
        {
            //call the GetVersionString function.
            //Returns the Version String unless there is an error.
            byte[] buffer = new byte[1024];
            int ID = System.Int16.Parse(isoVMfound, System.Globalization.NumberStyles.AllowHexSpecifier);
            int errnum = GetVersionString(ID, buffer);

            if (errnum == 0)
            {
                textBox1.AppendText("ERROR Function Call Failed\r\n");
                return;
            }

            Encoding.GetString(buffer, 0, 32).Replace("\0", "");
            textBox1.AppendText(Encoding.GetString(buffer).Replace("\0", ""));
            textBox1.AppendText("\r\n");
        }

        private void button6_Click(object sender, EventArgs e)
        {
            //call the ReadUSBisoVM function.
            //Returns the voltage of VM1 unless there is an error.
            byte[] buffer = new byte[1024];
            int ID = System.Int16.Parse(isoVMfound, System.Globalization.NumberStyles.AllowHexSpecifier);
            int errnum = ReadUSBisoVM(ID, 1, 1, buffer);

            if (errnum == 0)
            {
                textBox1.AppendText("ERROR Function Call Failed\r\n");
                return;
            }

            Encoding.GetString(buffer, 0, 32).Replace("\0", "");
            textBox1.AppendText(Encoding.GetString(buffer).Replace("\0", ""));
            textBox1.AppendText("\r\n");
        }

        private void button7_Click(object sender, EventArgs e)
        {
            //call the ReadUSBisoVM function.
            //Returns the voltage of VM1 unless there is an error.
            byte[] buffer = new byte[1024];
            int ID = System.Int16.Parse(isoVMfound, System.Globalization.NumberStyles.AllowHexSpecifier);
            int errnum = ReadUSBisoVM(ID, 2, 1, buffer);

            if (errnum == 0)
            {
                textBox1.AppendText("ERROR Function Call Failed\r\n");
                return;
            }

            Encoding.GetString(buffer, 0, 32).Replace("\0", "");
            textBox1.AppendText(Encoding.GetString(buffer).Replace("\0", ""));
            textBox1.AppendText("\r\n");
        }

        private void button8_Click(object sender, EventArgs e)
        {
            //call the ReadUSBisoVM function.
            //Returns the voltage of VM1 unless there is an error.
            byte[] buffer = new byte[1024];
            int ID = System.Int16.Parse(isoVMfound, System.Globalization.NumberStyles.AllowHexSpecifier);
            int errnum = ReadUSBisoVM(ID, 3, 1, buffer);

            if (errnum == 0)
            {
                textBox1.AppendText("ERROR Function Call Failed\r\n");
                return;
            }

            Encoding.GetString(buffer, 0, 32).Replace("\0", "");
            textBox1.AppendText(Encoding.GetString(buffer).Replace("\0", ""));
            textBox1.AppendText("\r\n");
        }

        private void button9_Click(object sender, EventArgs e)
        {
            //call the ReadUSBisoVM function.
            //Returns the voltage of VM1 unless there is an error.
            byte[] buffer = new byte[1024];
            int ID = System.Int16.Parse(isoVMfound, System.Globalization.NumberStyles.AllowHexSpecifier);
            int errnum = ReadUSBisoVM(ID, 4, 1, buffer);

            if (errnum == 0)
            {
                textBox1.AppendText("ERROR Function Call Failed\r\n");
                return;
            }

            Encoding.GetString(buffer, 0, 32).Replace("\0", "");
            textBox1.AppendText(Encoding.GetString(buffer).Replace("\0", ""));
            textBox1.AppendText("\r\n");
        }

        private void button10_Click(object sender, EventArgs e)
        {
            //call the ReadUSBisoVM function.
            //Returns the voltage of VM1 unless there is an error.
            byte[] buffer = new byte[1024];
            int ID = System.Int16.Parse(isoVMfound, System.Globalization.NumberStyles.AllowHexSpecifier);
            int errnum = ReadUSBisoVM(ID, 5, 1, buffer);

            if (errnum == 0)
            {
                textBox1.AppendText("ERROR Function Call Failed\r\n");
                return;
            }

            Encoding.GetString(buffer, 0, 32).Replace("\0", "");
            textBox1.AppendText(Encoding.GetString(buffer).Replace("\0", ""));
            textBox1.AppendText("\r\n");
        }

        private void button11_Click(object sender, EventArgs e)
        {
            //call the ReadUSBisoVM function.
            //Returns the voltage of VM1 unless there is an error.
            byte[] buffer = new byte[1024];
            int ID = System.Int16.Parse(isoVMfound, System.Globalization.NumberStyles.AllowHexSpecifier);
            int errnum = ReadUSBisoVM(ID, 6, 1, buffer);

            if (errnum == 0)
            {
                textBox1.AppendText("ERROR Function Call Failed\r\n");
                return;
            }

            Encoding.GetString(buffer, 0, 32).Replace("\0", "");
            textBox1.AppendText(Encoding.GetString(buffer).Replace("\0", ""));
            textBox1.AppendText("\r\n");
        }


       

    }
}
