﻿
Option Explicit On

Imports System.Runtime.InteropServices

Imports System.Text

'Declare Functions in the dll. The USBisoVM_DLL.dll must be in the same folder as the Project or EXE.
'Also note that the values are being passed ByRef and ByVal.

Module Module1
    <DllImport("USBisoVM_DLL.dll")> Public Function TestDLL(ByRef buffer As Byte) As Long
    End Function
    <DllImport("USBisoVM_DLL.dll")> Public Function FindUSBisoVMs(ByRef buffer As Byte) As Long
    End Function
    <DllImport("USBisoVM_DLL.dll")> Public Function GetManufacturerString(ByVal ID As Integer, ByRef buffer As Byte) As Long
    End Function
    <DllImport("USBisoVM_DLL.dll")> Public Function GetProductString(ByVal ID As Integer, ByRef buffer As Byte) As Long
    End Function
    <DllImport("USBisoVM_DLL.dll")> Public Function GetVersionString(ByVal ID As Integer, ByRef buffer As Byte) As Long
    End Function
    <DllImport("USBisoVM_DLL.dll")> Public Function ReadUSBisoVM(ByVal ID As Integer, ByVal VM As Integer, ByVal FORMAT As Integer, ByRef buffer As Byte) As Long
    End Function

    'Make a 1024 byte buffer that gets filled by the USBisoVM_DLL.dll
    Public buffer(1024) As Byte
    'Global variable that holds the first usb isolated voltmeter board found
    Public isoVMfound As String

End Module


Public Class Form1

    Private Sub Button1_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button1.Click
        Dim sdbuffer As String
        Dim errnum As Long
        Dim xx As Integer
        sdbuffer = ""
        errnum = TestDLL(buffer(0))
        For xx = 0 To 1023
            sdbuffer = sdbuffer & Chr(buffer(xx))
        Next
        TextBox1.Text = TextBox1.Text & sdbuffer
        TextBox1.Text = TextBox1.Text & vbCrLf
    End Sub

    Public Sub New()
        ' This call is required by the Windows Form Designer.
        InitializeComponent()
        ' Add any initialization after the InitializeComponent() call.
        TextBox1.Text = "(C)opyright 2010 EtherTek Circuits"
        TextBox1.Text = TextBox1.Text & vbCrLf
    End Sub

    Private Sub Button2_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button2.Click
        Dim sdbuffer As String
        Dim errnum As Long
        Dim xx As Integer
        sdbuffer = ""
        errnum = FindUSBisoVMs(buffer(0))
        For xx = 0 To 3
            sdbuffer = sdbuffer & Chr(buffer(xx))
        Next
        TextBox1.Text = TextBox1.Text & sdbuffer
        TextBox1.Text = TextBox1.Text & vbCrLf
        isoVMfound = sdbuffer
        Button3.Enabled = True
        Button4.Enabled = True
        Button5.Enabled = True
        Button6.Enabled = True
        Button7.Enabled = True
        Button8.Enabled = True
        Button9.Enabled = True
        Button10.Enabled = True
        Button11.Enabled = True
    End Sub

    Private Sub Button4_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button4.Click
        'call the GetProductString function.
        'Returns the Product String unless there is an error.
        Dim sdbuffer As String
        Dim errnum As Long
        Dim xx As Integer
        Dim ID As Integer
        sdbuffer = ""
        ID = CLng("&H" & isoVMfound)
        errnum = GetProductString(ID, buffer(0))
        If errnum = 0 Then
            TextBox1.Text = "ERROR Function Call Failed"
            Exit Sub
        End If

        For xx = 0 To 1023
            sdbuffer = sdbuffer & Chr(buffer(xx))
        Next

        TextBox1.Text = TextBox1.Text & sdbuffer
        TextBox1.Text = TextBox1.Text & vbCrLf
    End Sub

    Private Sub Button3_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button3.Click
        'call the GetManufacturerString function.
        'Returns the Manufacturer String unless there is an error.
        Dim sdbuffer As String
        Dim errnum As Long
        Dim xx As Integer
        Dim ID As Integer
        sdbuffer = ""
        ID = CLng("&H" & isoVMfound)
        errnum = GetManufacturerString(ID, buffer(0))
        If errnum = 0 Then
            TextBox1.Text = "ERROR Function Call Failed"
            Exit Sub
        End If

        For xx = 0 To 1023
            sdbuffer = sdbuffer & Chr(buffer(xx))
        Next

        TextBox1.Text = TextBox1.Text & sdbuffer
        TextBox1.Text = TextBox1.Text & vbCrLf
    End Sub

    Private Sub Button5_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button5.Click
        'call the GetVersionString function.
        'Returns the Version String unless there is an error.
        Dim sdbuffer As String
        Dim errnum As Long
        Dim xx As Integer
        Dim ID As Integer
        sdbuffer = ""
        ID = CLng("&H" & isoVMfound)
        errnum = GetVersionString(ID, buffer(0))
        If errnum = 0 Then
            TextBox1.Text = "ERROR Function Call Failed"
            Exit Sub
        End If

        For xx = 0 To 1023
            sdbuffer = sdbuffer & Chr(buffer(xx))
        Next

        TextBox1.Text = TextBox1.Text & sdbuffer
        TextBox1.Text = TextBox1.Text & vbCrLf
    End Sub

    Private Sub Button6_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button6.Click
        'call the ReadUSBisoVM function.
        'Returns the voltage of VM1 unless there is an error.
        Dim sdbuffer As String
        Dim errnum As Long
        Dim xx As Integer
        Dim ID As Integer
        sdbuffer = ""
        ID = CLng("&H" & isoVMfound)
        errnum = ReadUSBisoVM(ID, 1, 1, buffer(0))
        If errnum = 0 Then
            TextBox1.Text = "ERROR Function Call Failed"
            Exit Sub
        End If

        For xx = 0 To 1023
            sdbuffer = sdbuffer & Chr(buffer(xx))
        Next

        TextBox1.Text = TextBox1.Text & sdbuffer
        TextBox1.Text = TextBox1.Text & vbCrLf
    End Sub

    Private Sub Button7_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button7.Click
        'call the ReadUSBisoVM function.
        'Returns the voltage of VM2 unless there is an error.
        Dim sdbuffer As String
        Dim errnum As Long
        Dim xx As Integer
        Dim ID As Integer
        sdbuffer = ""
        ID = CLng("&H" & isoVMfound)
        errnum = ReadUSBisoVM(ID, 2, 1, buffer(0))
        If errnum = 0 Then
            TextBox1.Text = "ERROR Function Call Failed"
            Exit Sub
        End If

        For xx = 0 To 1023
            sdbuffer = sdbuffer & Chr(buffer(xx))
        Next

        TextBox1.Text = TextBox1.Text & sdbuffer
        TextBox1.Text = TextBox1.Text & vbCrLf
    End Sub

    Private Sub Button8_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button8.Click
        'call the ReadUSBisoVM function.
        'Returns the voltage of VM3 unless there is an error.
        Dim sdbuffer As String
        Dim errnum As Long
        Dim xx As Integer
        Dim ID As Integer
        sdbuffer = ""
        ID = CLng("&H" & isoVMfound)
        errnum = ReadUSBisoVM(ID, 3, 1, buffer(0))
        If errnum = 0 Then
            TextBox1.Text = "ERROR Function Call Failed"
            Exit Sub
        End If

        For xx = 0 To 1023
            sdbuffer = sdbuffer & Chr(buffer(xx))
        Next

        TextBox1.Text = TextBox1.Text & sdbuffer
        TextBox1.Text = TextBox1.Text & vbCrLf
    End Sub

    Private Sub Button9_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button9.Click
        'call the ReadUSBisoVM function.
        'Returns the voltage of VM4 unless there is an error.
        Dim sdbuffer As String
        Dim errnum As Long
        Dim xx As Integer
        Dim ID As Integer
        sdbuffer = ""
        ID = CLng("&H" & isoVMfound)
        errnum = ReadUSBisoVM(ID, 4, 1, buffer(0))
        If errnum = 0 Then
            TextBox1.Text = "ERROR Function Call Failed"
            Exit Sub
        End If

        For xx = 0 To 1023
            sdbuffer = sdbuffer & Chr(buffer(xx))
        Next

        TextBox1.Text = TextBox1.Text & sdbuffer
        TextBox1.Text = TextBox1.Text & vbCrLf
    End Sub

    Private Sub Button10_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button10.Click
        'call the ReadUSBisoVM function.
        'Returns the voltage of VM5 unless there is an error.
        Dim sdbuffer As String
        Dim errnum As Long
        Dim xx As Integer
        Dim ID As Integer
        sdbuffer = ""
        ID = CLng("&H" & isoVMfound)
        errnum = ReadUSBisoVM(ID, 5, 1, buffer(0))
        If errnum = 0 Then
            TextBox1.Text = "ERROR Function Call Failed"
            Exit Sub
        End If

        For xx = 0 To 1023
            sdbuffer = sdbuffer & Chr(buffer(xx))
        Next

        TextBox1.Text = TextBox1.Text & sdbuffer
        TextBox1.Text = TextBox1.Text & vbCrLf
    End Sub

    Private Sub Button11_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button11.Click
        'call the ReadUSBisoVM function.
        'Returns the voltage of VM6 unless there is an error.
        Dim sdbuffer As String
        Dim errnum As Long
        Dim xx As Integer
        Dim ID As Integer
        sdbuffer = ""
        ID = CLng("&H" & isoVMfound)
        errnum = ReadUSBisoVM(ID, 6, 1, buffer(0))
        If errnum = 0 Then
            TextBox1.Text = "ERROR Function Call Failed"
            Exit Sub
        End If

        For xx = 0 To 1023
            sdbuffer = sdbuffer & Chr(buffer(xx))
        Next

        TextBox1.Text = TextBox1.Text & sdbuffer
        TextBox1.Text = TextBox1.Text & vbCrLf
    End Sub
End Class
